// Version/Precision tags are added programmatically on shader load

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;
attribute vec2 vaUV;

//(x, y, z) -> (x , y + AmplitudeGrowth * x * sin(Frequency * y + Skew * z + Time), z)
uniform float uTime;
uniform float uFrequency;
uniform float uRadius;
uniform float uAmplitudeGrowth;
uniform float uSkew;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mModel;
uniform vec3 uLightPos;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying vec2 UV; // UV

void main()
{
  float edge = uRadius * uRadius;
  float currentRadius = vPosition.x * vPosition.x + vPosition.y * vPosition.y;
  float needTransform = step(edge, currentRadius);
  float wave = uAmplitudeGrowth * vPosition.x * sin(uFrequency * vPosition.x + uSkew * vPosition.z - uTime);
  wave *= needTransform;
  
  float inside = uTime - uFrequency * vPosition.x - uSkew * vPosition.z;
  float nx = uAmplitudeGrowth * (sin(inside) - uFrequency * vPosition.x * cos(inside));
  float ny = 1.0;
  float nz = -uAmplitudeGrowth * uSkew * vPosition.x * cos(inside);
  vec3 newNormal = normalize(vec3(nx,ny,nz));
  float needRevert = step(0.0, dot(newNormal, vaNormal));
  newNormal.y = needRevert * newNormal.y + (needRevert - 1.0) * newNormal.y; 
  
  C = vaColor;
  L = normalize(mat3(mView) * uLightPos);
  N = normalize(abs(needTransform - 1.0) * normalize(mat3(mView) * mat3(mModel) * vaNormal) + needTransform * normalize(mat3(mView) * mat3(mModel) * newNormal));
  P = vec3(mModel * vec4(vPosition, 1.0));
  UV = vaUV;
  
  gl_Position = mProj * mView * mModel * vec4(vPosition.x, vPosition.y + wave, vPosition.z, 1.0);
}